﻿Public Class frmRendas

    Private Sub frmRendas_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        dgvDados.Columns(colValor.Index).DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleRight
        dgvDados.Columns(colValor.Index).DefaultCellStyle.Format = "#,##0.00 €"
        subRebuildArvore()
        subLerAnos()
        cmbAno.SelectedItem = Now.Year
    End Sub
    Private Sub tvwRendas_AfterSelect(ByVal sender As System.Object, ByVal e As System.Windows.Forms.TreeViewEventArgs) Handles tvwRendas.AfterSelect
        Try
            Dim bolNodeSeleccionado As Boolean = False
            For Each node As TreeNode In tvwRendas.Nodes(0).Nodes
                node.BackColor = Color.White
                If node.IsSelected Then bolNodeSeleccionado = True
            Next
            If bolNodeSeleccionado Then
                If tvwRendas.SelectedNode.Tag <> "Rendas" Then
                    subLerRenda()
                    tvwRendas.SelectedNode.BackColor = Color.Aqua
                    txbDesignação.Text = tvwRendas.SelectedNode.Text
                Else
                    subLimpaValores()
                End If
            End If
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    Private Sub cmbAno_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbAno.SelectedIndexChanged
        Try
            Dim bolNodeSeleccionado As Boolean = False
            For Each node As TreeNode In tvwRendas.Nodes(0).Nodes
                node.BackColor = Color.White
                If node.IsSelected Then bolNodeSeleccionado = True
            Next
            If bolNodeSeleccionado Then
                If tvwRendas.SelectedNode.Tag <> "Rendas" Then
                    subLerRenda()
                    tvwRendas.SelectedNode.BackColor = Color.Aqua
                    txbDesignação.Text = tvwRendas.SelectedNode.Text
                Else
                    subLimpaValores()
                End If
            End If
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' Vamos criar um funcionário novo
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnNovo_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnNovo.Click
        Try
            subLimpaValores()
            subRebuildArvore()
            txbDesignação.Text = StrConv(InputBox("Designação da renda:"), VbStrConv.ProperCase)
            If txbDesignação.Text <> "" Then
                dgvDados.Rows.Clear()
                dgvDados.Rows.Add("Janeiro", 0.0)
                dgvDados.Rows.Add("Fevereiro", 0.0)
                dgvDados.Rows.Add("Março", 0.0)
                dgvDados.Rows.Add("Abril", 0.0)
                dgvDados.Rows.Add("Maio", 0.0)
                dgvDados.Rows.Add("Junho", 0.0)
                dgvDados.Rows.Add("Julho", 0.0)
                dgvDados.Rows.Add("Agosto", 0.0)
                dgvDados.Rows.Add("Setembro", 0.0)
                dgvDados.Rows.Add("Outubro", 0.0)
                dgvDados.Rows.Add("Novembro", 0.0)
                dgvDados.Rows.Add("Dezembro", 0.0)
                cmbAno.SelectedItem = Now.Year
                'subLimpaValores()
                subGravarValores()
                subRebuildArvore()
            End If
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    Private Sub btnGravar_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGravar.Click
        subGravarValores()
        subLerRenda()
    End Sub
    Private Sub subRebuildArvore()
        Try
            tvwRendas.Nodes.Clear()
            Dim strRendasSQL As String = "SELECT DISTINCT Designação FROM Rendas ORDER BY Designação ASC"

            Dim dsRendas As New DataSet
            Dim sqlConn As New SqlConnection(Settings.strSQLConnection)
            Dim daRendas As New SqlDataAdapter(strRendasSQL, Settings.strSQLConnection)

            sqlConn.Open()
            daRendas.Fill(dsRendas, "Designação")
            sqlConn.Close()

            tvwRendas.BeginUpdate()
            Dim nodeRoot As TreeNode
            nodeRoot = New TreeNode
            nodeRoot.Text = "Rendas"
            nodeRoot.Tag = "Rendas"
            tvwRendas.Nodes.Add(nodeRoot)

            For Each Row As DataRow In dsRendas.Tables("Designação").Rows
                Dim nodeRenda As TreeNode
                nodeRenda = New TreeNode
                nodeRenda.Text = Row("Designação").ToString.Trim
                nodeRenda.Tag = Row("Designação").ToString.Trim
                nodeRoot.Nodes.Add(nodeRenda)
            Next
            tvwRendas.EndUpdate()
        Catch ex As Exception
            modLog.subErro(ex)
        Finally
            tvwRendas.ExpandAll()
        End Try
    End Sub
    ''' <summary>
    ''' Lê todos os dados relativos ao Funcionário seleccionado
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub subLerRenda()
        Try
            Dim strRendaSQL As String = "SELECT * FROM Rendas WHERE Designação='" & tvwRendas.SelectedNode.Tag & "' AND Ano='" & Int(cmbAno.SelectedItem.ToString) & "' ORDER BY Mês ASC"

            Dim sqlConn As New SqlConnection(Settings.strSQLConnection)
            Dim commandFuncionário As New SqlCommand(strRendaSQL, sqlConn)
            sqlConn.Open()

            ' Executa o comando colocando num SqlDataReader os resultados
            Dim readerFuncionário As SqlDataReader = commandFuncionário.ExecuteReader()
            ' Caso existam rows (linhas)

            If readerFuncionário.HasRows Then
                ' Executa um ciclo nas linhas existentes mostrando o campo “username”
                dgvDados.Rows.Clear()
                While readerFuncionário.Read()
                    Dim strMês As String = ""
                    Select Case readerFuncionário.Item("Mês")
                        Case 1
                            strMês = "Janeiro"
                        Case 2
                            strMês = "Fevereiro"
                        Case 3
                            strMês = "Março"
                        Case 4
                            strMês = "Abril"
                        Case 5
                            strMês = "Maio"
                        Case 6
                            strMês = "Junho"
                        Case 7
                            strMês = "Julho"
                        Case 8
                            strMês = "Agosto"
                        Case 9
                            strMês = "Setembro"
                        Case 10
                            strMês = "Outubro"
                        Case 11
                            strMês = "Novembro"
                        Case 12
                            strMês = "Dezembro"
                    End Select
                    dgvDados.Rows.Add(strMês, readerFuncionário.Item("Valor"))
                End While
            Else
                If cmbAno.SelectedItem = Now.Year Then
                    dgvDados.Rows.Clear()
                    dgvDados.Rows.Add("Janeiro", 0.0)
                    dgvDados.Rows.Add("Fevereiro", 0.0)
                    dgvDados.Rows.Add("Março", 0.0)
                    dgvDados.Rows.Add("Abril", 0.0)
                    dgvDados.Rows.Add("Maio", 0.0)
                    dgvDados.Rows.Add("Junho", 0.0)
                    dgvDados.Rows.Add("Julho", 0.0)
                    dgvDados.Rows.Add("Agosto", 0.0)
                    dgvDados.Rows.Add("Setembro", 0.0)
                    dgvDados.Rows.Add("Outubro", 0.0)
                    dgvDados.Rows.Add("Novembro", 0.0)
                    dgvDados.Rows.Add("Dezembro", 0.0)
                Else
                    subLimpaValores()
                End If
            End If

            ' Fecha a ligação e limpa as variáveis
            sqlConn.Close()
            sqlConn = Nothing
            commandFuncionário = Nothing
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    Private Sub subLerAnos()
        Try
            Dim strAnoSQL As String = "SELECT DISTINCT Ano FROM Rendas ORDER BY Ano DESC"

            Dim sqlConn As New SqlConnection(Settings.strSQLConnection)
            Dim commandAno As New SqlCommand(strAnoSQL, sqlConn)
            sqlConn.Open()

            ' Executa o comando colocando num SqlDataReader os resultados
            Dim readerFuncionário As SqlDataReader = commandAno.ExecuteReader()
            ' Caso existam rows (linhas)

            cmbAno.Items.Clear()
            If readerFuncionário.HasRows Then
                ' Executa um ciclo nas linhas existentes mostrando o campo “username”
                While readerFuncionário.Read()
                    cmbAno.Items.Add(readerFuncionário.Item("Ano"))
                End While
            End If

            Dim bolAnoActual As Boolean = False
            If cmbAno.Items.Count > 0 Then
                For Each s As String In cmbAno.Items
                    If Int(s) = Now.Year Then
                        'cmbAno.SelectedItem = Now.Year
                        bolAnoActual = True
                        Exit For
                    End If
                Next
            End If
            If Not bolAnoActual Then
                cmbAno.Items.Add(Now.Year)
                cmbAno.SelectedItem = Now.Year
            End If

            ' Fecha a ligação e limpa as variáveis
            sqlConn.Close()
            sqlConn = Nothing
            commandAno = Nothing
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    Private Function funTestaValores() As Boolean
        Try
            If txbDesignação.Text.Trim = "" Then
                MsgBox("Designação não preenchida!")
                Return False
            End If
            If txbDesignação.Text.Trim.Length > 50 Then
                MsgBox("Designação muito comprida (máx.50 caracteres)!")
                Return False
            End If
            For Each row As DataGridViewRow In dgvDados.Rows
                If Not row.IsNewRow Then
                    If IsNumeric(dgvDados.Rows(row.Index).Cells(colValor.Index).Value) Then
                        If dgvDados.Rows(row.Index).Cells(colValor.Index).Value < 0 Then
                            MsgBox("Valor da Renda negativo!")
                            dgvDados.Rows(row.Index).DefaultCellStyle.ForeColor = Color.Red
                            Return False
                        Else
                            dgvDados.Rows(row.Index).DefaultCellStyle.ForeColor = Color.Black
                        End If
                    Else
                        MsgBox("Valor da Renda não é um número!")
                        dgvDados.Rows(row.Index).DefaultCellStyle.ForeColor = Color.Red
                        Return False
                    End If
                End If
            Next
            Return True
        Catch ex As Exception
            modLog.subErro(ex)
            Return False
        End Try
    End Function
    ''' <summary>
    ''' Rotina que limpa todos os dados das textboxs e da tabela
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub subLimpaValores()
        dgvDados.Rows.Clear()
        txbDesignação.Clear()
    End Sub
    Private Sub subGravarValores()
        Try
            If funTestaValores() Then
                Dim x As Integer

                ' Inserimos ou actualizamos os dados dos funcionários na tabela Funcionários
                ' 
                'IF EXISTS (SELECT * FROM Table1 WHERE Column1='SomeValue')
                'UPDATE Table1 SET (...) WHERE Column1='SomeValue'
                'Else
                'INSERT INTO Table1 VALUES (...)
                Dim strRendaSQL As String = ""
                For Each row As DataGridViewRow In dgvDados.Rows
                    If Not row.IsNewRow Then
                        strRendaSQL += " IF EXISTS "
                        strRendaSQL += " (SELECT Designação, Ano FROM Rendas WHERE "
                        strRendaSQL += " Designação ='" & StrConv(txbDesignação.Text.Trim, VbStrConv.ProperCase) & "' AND "
                        strRendaSQL += " Ano ='" & Int(cmbAno.SelectedItem.ToString) & "' AND "
                        strRendaSQL += " Mês ='" & row.Index + 1 & "' "
                        strRendaSQL += ") "
                        strRendaSQL += " UPDATE Rendas SET "
                        strRendaSQL += " Valor=Convert(real," & row.Cells(colValor.Index).Value.ToString.Replace(",", ".").Replace("€", "").Replace("%", "").Replace(" ", "") & ") "
                        strRendaSQL += " WHERE "
                        strRendaSQL += " Designação ='" & StrConv(txbDesignação.Text.Trim, VbStrConv.ProperCase) & "' AND "
                        strRendaSQL += " Ano ='" & Int(cmbAno.SelectedItem.ToString) & "' AND "
                        strRendaSQL += " Mês ='" & row.Index + 1 & "' "
                        strRendaSQL += " ELSE "
                        strRendaSQL += " INSERT INTO Rendas VALUES ("
                        strRendaSQL += " '" & StrConv(txbDesignação.Text.Trim, VbStrConv.ProperCase) & "',"
                        strRendaSQL += " '" & Int(cmbAno.SelectedItem.ToString) & "', "
                        strRendaSQL += " '" & row.Index + 1 & "', "
                        strRendaSQL += " Convert(real," & row.Cells(colValor.Index).Value.ToString.Replace(",", ".").Replace("€", "").Replace("%", "").Replace(" ", "") & ") "
                        strRendaSQL += ") "

                    End If
                Next
                Dim sqlConn As New SqlConnection(Settings.strSQLConnection)
                Dim execRenda As New SqlCommand(strRendaSQL, sqlConn)
                sqlConn.Open()
                x = execRenda.ExecuteNonQuery
                sqlConn.Close()
                sqlConn = Nothing
                execRenda = Nothing
                strRendaSQL = Nothing

                subRebuildArvore()
                For Each N As TreeNode In tvwRendas.Nodes
                    If N.Text = txbDesignação.Text Then tvwRendas.SelectedNode = N
                    If N.Nodes.Count > 0 Then EscavaNodes(N, txbDesignação.Text)
                Next
            End If
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' Procura nodes dentro de nodes na treeview
    ''' </summary>
    ''' <param name="NodeInicial"></param>
    ''' <param name="EncontraOQue"></param>
    ''' <remarks></remarks>
    Private Sub EscavaNodes(ByVal NodeInicial As TreeNode, ByVal EncontraOQue As String)
        For Each N As TreeNode In NodeInicial.Nodes
            If N.Text = EncontraOQue Then tvwRendas.SelectedNode = N
            If N.Nodes.Count > 0 Then EscavaNodes(N, EncontraOQue)
        Next
    End Sub
End Class